/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import com.mojang.blaze3d.systems.RenderSystem;
import moe.ytonidc.dimensional_stomach.StomachConfig;
import moe.ytonidc.dimensional_stomach.StomachMenu;
import moe.ytonidc.dimensional_stomach.StomachNetwork;
import moe.ytonidc.dimensional_stomach.StomachSlotManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StomachScreen
extends AbstractContainerScreen<StomachMenu> {
    private static final ResourceLocation RED_TEXTURE = new ResourceLocation("dimensional_stomach", "textures/gui/red_stomach.png");
    private static final ResourceLocation BLUE_TEXTURE = new ResourceLocation("dimensional_stomach", "textures/gui/blue_stomach.png");
    private static final ResourceLocation YELLOW_TEXTURE = new ResourceLocation("dimensional_stomach", "textures/gui/yellow_stomach.png");
    private static final ResourceLocation RED_BUTTON = new ResourceLocation("dimensional_stomach", "textures/gui/button/red.png");
    private static final ResourceLocation BLUE_BUTTON = new ResourceLocation("dimensional_stomach", "textures/gui/button/blue.png");
    private static final ResourceLocation YELLOW_BUTTON = new ResourceLocation("dimensional_stomach", "textures/gui/button/yellow.png");
    private static final int BUTTON_SIZE = 19;
    private static final int TEXTURE_WIDTH = 233;
    private static final int TEXTURE_HEIGHT = 242;
    private static final int TEXTURE_OFFSET_X = -25;
    private static final int TEXTURE_OFFSET_Y = -41;
    private final StomachSlotManager.SlotType slotType;
    private final String title;
    private float rainbowTimer = 0.0f;
    private StomachSlotManager.SlotType button1Type;
    private StomachSlotManager.SlotType button2Type;

    public StomachScreen(StomachMenu menu, Inventory playerInventory, Component titleComponent) {
        super((AbstractContainerMenu)menu, playerInventory, titleComponent);
        this.slotType = menu.getSlotType();
        this.f_97726_ = 176;
        this.f_97727_ = 184;
        this.f_97731_ = this.f_97727_ - 94;
        this.title = switch (this.slotType) {
            default -> throw new IncompatibleClassChangeError();
            case StomachSlotManager.SlotType.RED -> "\u653b\u51fb\u4e4b\u80c3";
            case StomachSlotManager.SlotType.BLUE -> "\u901f\u5ea6\u4e4b\u80c3";
            case StomachSlotManager.SlotType.YELLOW -> "\u654f\u6377\u4e4b\u80c3";
        };
    }

    private ResourceLocation getTexture() {
        return switch (this.slotType) {
            default -> throw new IncompatibleClassChangeError();
            case StomachSlotManager.SlotType.RED -> RED_TEXTURE;
            case StomachSlotManager.SlotType.BLUE -> BLUE_TEXTURE;
            case StomachSlotManager.SlotType.YELLOW -> YELLOW_TEXTURE;
        };
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = -9999;
        int x = this.f_97735_;
        int y = this.f_97736_;
        StomachSlotManager.SlotType[] others = this.getOtherTypes();
        this.button1Type = others[0];
        this.button2Type = others[1];
        this.m_142416_((GuiEventListener)new StomachSwitchButton(x + this.f_97726_ + 4, y + 18, this.button1Type, this));
        this.m_142416_((GuiEventListener)new StomachSwitchButton(x + this.f_97726_ + 4, y + 40, this.button2Type, this));
    }

    private StomachSlotManager.SlotType[] getOtherTypes() {
        StomachSlotManager.SlotType[] slotTypeArray;
        switch (this.slotType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RED: {
                StomachSlotManager.SlotType[] slotTypeArray2 = new StomachSlotManager.SlotType[2];
                slotTypeArray2[0] = StomachSlotManager.SlotType.BLUE;
                slotTypeArray = slotTypeArray2;
                slotTypeArray2[1] = StomachSlotManager.SlotType.YELLOW;
                break;
            }
            case BLUE: {
                StomachSlotManager.SlotType[] slotTypeArray3 = new StomachSlotManager.SlotType[2];
                slotTypeArray3[0] = StomachSlotManager.SlotType.RED;
                slotTypeArray = slotTypeArray3;
                slotTypeArray3[1] = StomachSlotManager.SlotType.YELLOW;
                break;
            }
            case YELLOW: {
                StomachSlotManager.SlotType[] slotTypeArray4 = new StomachSlotManager.SlotType[2];
                slotTypeArray4[0] = StomachSlotManager.SlotType.RED;
                slotTypeArray = slotTypeArray4;
                slotTypeArray4[1] = StomachSlotManager.SlotType.BLUE;
            }
        }
        return slotTypeArray;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_ + -25;
        int y = this.f_97736_ + -41;
        ResourceLocation texture = this.getTexture();
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 233, 242, 233, 242);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.rainbowTimer += partialTick * 0.05f;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSpecialSlotHighlights(guiGraphics);
        this.renderRainbowTitle(guiGraphics);
        this.renderSlotInfo(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderRainbowTitle(GuiGraphics guiGraphics) {
        String[] stringArray;
        int textX = this.f_97735_ - 90;
        int textY = this.f_97736_ + 10;
        double bonus = ((StomachMenu)this.f_97732_).getBonus();
        int charX = textX;
        for (int i = 0; i < this.title.length(); ++i) {
            String charStr = String.valueOf(this.title.charAt(i));
            int color = this.getRainbowColor(i, this.title.length());
            guiGraphics.m_280056_(this.f_96547_, charStr, charX, textY, color | 0xFF000000, false);
            charX += this.f_96547_.m_92895_(charStr);
        }
        textY += 14;
        switch (this.slotType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RED: {
                String[] stringArray2 = new String[2];
                stringArray2[0] = String.format("\u653b\u51fb +%.1f", bonus * (Double)StomachConfig.COMMON.redAttackMultiplier.get());
                stringArray = stringArray2;
                stringArray2[1] = String.format("\u8840\u91cf +%.1f", bonus * (Double)StomachConfig.COMMON.redHealthMultiplier.get());
                break;
            }
            case BLUE: {
                String[] stringArray3 = new String[2];
                stringArray3[0] = String.format("\u653b\u901f +%.2f", bonus * (Double)StomachConfig.COMMON.blueAttackSpeedMultiplier.get());
                stringArray = stringArray3;
                stringArray3[1] = String.format("\u6297\u6027 +%.2f", bonus * (Double)StomachConfig.COMMON.blueKnockbackResistMultiplier.get());
                break;
            }
            case YELLOW: {
                String[] stringArray4 = new String[2];
                stringArray4[0] = String.format("\u79fb\u901f +%.2f", bonus * (Double)StomachConfig.COMMON.yellowMovementSpeedMultiplier.get());
                stringArray = stringArray4;
                stringArray4[1] = String.format("\u62a4\u7532 +%.1f", bonus * (Double)StomachConfig.COMMON.yellowArmorMultiplier.get());
            }
        }
        String[] attrLines = stringArray;
        int attrColor = switch (this.slotType) {
            default -> throw new IncompatibleClassChangeError();
            case StomachSlotManager.SlotType.RED -> -39322;
            case StomachSlotManager.SlotType.BLUE -> -10027162;
            case StomachSlotManager.SlotType.YELLOW -> -154;
        };
        for (String line : attrLines) {
            guiGraphics.m_280056_(this.f_96547_, line, textX, textY, attrColor, false);
            textY += 11;
        }
    }

    private void renderSlotInfo(GuiGraphics guiGraphics) {
        int textX = this.f_97735_ - 90;
        int textY = this.f_97736_ + 60;
        int unlocked = ((StomachMenu)this.f_97732_).getUnlockedSlots();
        int level = ((StomachMenu)this.f_97732_).getStomachLevel();
        guiGraphics.m_280056_(this.f_96547_, "\u7b49\u7ea7: Lv." + level, textX, textY, -1, false);
        guiGraphics.m_280056_(this.f_96547_, "\u69fd\u4f4d: " + unlocked + "/36", textX, textY += 11, -5592406, false);
    }

    private void renderSpecialSlotHighlights(GuiGraphics guiGraphics) {
        int guiX = this.f_97735_;
        int guiY = this.f_97736_;
        int unlocked = ((StomachMenu)this.f_97732_).getUnlockedSlots();
        float pulse = (float)Math.sin(this.rainbowTimer * 4.0f) * 0.3f + 0.7f;
        int alpha = (int)(pulse * 255.0f);
        int highlightColor = alpha << 24 | 0xFFD700;
        int slotSize = 18;
        int slotsPerRow = 9;
        int rows = 4;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < slotsPerRow; ++col) {
                int index = row * slotsPerRow + col;
                if (index >= unlocked || !StomachSlotManager.isSpecialSlot(index)) continue;
                int slotX = guiX + 8 + col * slotSize - 1;
                int slotY = guiY + 18 + row * slotSize - 1;
                guiGraphics.m_280637_(slotX, slotY, slotSize, slotSize, highlightColor);
            }
        }
    }

    private int getRainbowColor(int charIndex, int totalChars) {
        float hue = (this.rainbowTimer + (float)charIndex / (float)totalChars) % 1.0f;
        return this.hsvToRgb(hue, 0.8f, 1.0f);
    }

    private int hsvToRgb(float h, float s, float v) {
        float g;
        float r;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)((switch (i % 6) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        }) * 255.0f);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class StomachSwitchButton
    extends Button {
        private final StomachSlotManager.SlotType targetType;
        private final ResourceLocation buttonTexture;

        public StomachSwitchButton(int x, int y, StomachSlotManager.SlotType targetType, StomachScreen screen) {
            super(x, y, 19, 19, (Component)Component.m_237119_(), btn -> StomachNetwork.sendOpenGuiPacket(targetType), f_252438_);
            this.targetType = targetType;
            this.buttonTexture = switch (targetType) {
                default -> throw new IncompatibleClassChangeError();
                case StomachSlotManager.SlotType.RED -> RED_BUTTON;
                case StomachSlotManager.SlotType.BLUE -> BLUE_BUTTON;
                case StomachSlotManager.SlotType.YELLOW -> YELLOW_BUTTON;
            };
            String name = switch (targetType) {
                default -> throw new IncompatibleClassChangeError();
                case StomachSlotManager.SlotType.RED -> "\u653b\u51fb\u4e4b\u80c3";
                case StomachSlotManager.SlotType.BLUE -> "\u901f\u5ea6\u4e4b\u80c3";
                case StomachSlotManager.SlotType.YELLOW -> "\u654f\u6377\u4e4b\u80c3";
            };
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)name)));
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280163_(this.buttonTexture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 19, 19, 19, 19);
            if (this.f_93622_) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 19, this.m_252907_() + 19, 0x40FFFFFF);
            }
        }
    }
}

